local t = Def.ActorFrame {};

--[[t[#t+1] = Def.Quad {
	InitCommand=function(self) self:Center():FullScreen():diffuse(color("#000000")):diffusealpha(1) end;
};]]
if GAMESTATE:IsCourseMode() then
	t[#t+1] = LoadActor("_courseintro") .. {};	
else
	local song = GAMESTATE:GetCurrentSong();
	local stage = GAMESTATE:GetCurrentStage();
	local diff = GAMESTATE:GetCurrentSteps(PLAYER_1);
	local diffn = diff:GetChartName();
	local diffr = diff:GetMeter();
	local gate = "ULTRA GATE";
	local gate2 = "ULTRA EX";
	local s_stage = ToEnumShortString(stage);
	local sname = song:GetDisplayMainTitle();
	local ssname = song:GetDisplaySubTitle();
	if ssname == "" then ssname = nil end
	local sartist = song:GetDisplayArtist();
	local sbg = song:GetBackgroundPath();
	local jkt = song:GetJacketPath();
	local bn = song:GetBannerPath();
	if GAMESTATE:IsExtraStage2(true) then
		t[#t+1] = LoadActor("_another") .. {};
	elseif GAMESTATE:IsExtraStage(true) then
		t[#t+1] = LoadActor("_extra") .. {};
	elseif diffr == 999 then
		t[#t+1] = LoadActor("_max") .. {};
	elseif diffn == gate or diffn == gate2 then
		t[#t+1] = LoadActor("_gate") .. {};
	else
		local cx = SCREEN_CENTER_X;
		local cy = SCREEN_CENTER_Y;
		t[#t+1] = Def.Quad { -- background
			InitCommand=function(self) self:FullScreen():diffuse(color("#000000")):diffusealpha(1) end;
		};
		t[#t+1] = LoadActor("_grid")..{
			InitCommand=function(self) self:Center():diffusealpha(0) end;
			OnCommand=function(self) self:sleep(4.6):decelerate(0.5):diffusealpha(0.5):smooth(0.5):diffusealpha(0.25):sleep(0.2):linear(0.3):diffusealpha(0.4) end;
		};
		t[#t+1] = LoadActor("_motion")..{
			InitCommand=function(self) self:Center():addy(-4500) end;
			OnCommand=function(self) self:sleep(1.4):linear(2.3):addy(9000) end;
		};
		if song:HasJacket() then
			t[#t+1] = LoadActor("_jacketframe")..{
				InitCommand=function(self) self:Center():scaletofit(cx-152.5,cy-80,cx+152.5,cy+80):addy(375) end;
				OnCommand=function(self) self:sleep(1):linear(2.5):addy(-375):rotationy(2880):sleep(1.9):linear(0.3):diffusealpha(0) end;
			};
			t[#t+1] = LoadActor(jkt)..{
				InitCommand=function(self) self:Center():diffusealpha(0) end;
				OnCommand=function(self) self:sleep(4):diffusealpha(1):scaletofit(cx-79,cy-79,cx+79,cy+79):sleep(1.7):linear(0.3):diffusealpha(0) end;
			};
			t[#t+1] = Def.Quad { -- white square; power
				InitCommand=function(self) self:Center():zoomx(0):zoomy(1):diffuse(color("#FFFFFF")):diffusealpha(1) end;
				OnCommand=function(self) self:sleep(3.8):linear(0.1):zoomx(160):linear(0.1):zoomy(160):linear(0.3):diffusealpha(0) end;
			};
		elseif song:HasBanner() then
			t[#t+1] = LoadActor("_commonbannerframe")..{
				InitCommand=function(self) self:Center():scaletofit(cx-152.5,cy-80,cx+152.5,cy+80):addy(400) end;
				OnCommand=function(self) self:sleep(1):linear(2.5):addy(-400):rotationy(2880):sleep(2):linear(0.3):diffusealpha(0) end;
			};
			t[#t+1] = LoadActor(bn)..{
					InitCommand=function(self) self:Center():diffusealpha(0) end;
					OnCommand=function(self) -- check banner size, resize accordingly
						local w = self:GetWidth();
						local h = self:GetHeight();
						if w == 256 and h == 80 then -- classic common size
							self:sleep(4):diffusealpha(1):scaletofit(cx-150,cy-150,cx+150,cy+150):sleep(1.7):linear(0.3):diffusealpha(0);
						elseif w == 418 and h == 164 then -- modern common size
							self:sleep(4):diffusealpha(1):scaletofit(cx-150,cy-150,cx+150,cy+150):zoomy(0.55):sleep(1.7):linear(0.3):diffusealpha(0);
						end
					end;
			};
			t[#t+1] = Def.Quad { -- white square; power
				InitCommand=function(self) self:Center():zoomx(0):zoomy(1):diffuse(color("#FFFFFF")):diffusealpha(1) end;
				OnCommand=function(self) self:sleep(3.8):linear(0.1):zoomx(300):linear(0.1):zoomy(93):linear(0.3):diffusealpha(0) end;
			};
		else
			t[#t+1] = LoadActor("_jacketframe")..{
				InitCommand=function(self) self:Center():scaletofit(cx-152.5,cy-80,cx+152.5,cy+80):addy(400) end;
				OnCommand=function(self) self:sleep(1):linear(2.5):addy(-400):rotationy(2880) end;
			};
			t[#t+1] = LoadActor(THEME:GetPathG("", "Common fallback jacket"))..{
				InitCommand=function(self) self:Center():diffusealpha(0) end;
				OnCommand=function(self) self:sleep(4):diffusealpha(1):scaletofit(cx-75,cy-75,cx+75,cy+75) end;
			};
			t[#t+1] = Def.Quad { -- white square; power
				InitCommand=function(self) self:Center():zoomx(0):zoomy(1):diffuse(color("#FFFFFF")):diffusealpha(1) end;
				OnCommand=function(self) self:sleep(3.8):linear(0.1):zoomx(155):linear(0.1):zoomy(155):linear(0.3):diffusealpha(0) end;
			};
		end
		t[#t+1] = LoadActor("_imagespawn")..{
			OnCommand=function(self) self:sleep(3.7):queuecommand("Play") end;
			PlayCommand=function(self) self:play() end;
		};
		t[#t+1] = LoadActor(THEME:GetPathG("ScreenStageInformation", "Stage "..s_stage))..{
			InitCommand=function(self) self:Center():addy(200):diffusealpha(0):zoom(0.6) end;
			OnCommand=function(self) self:sleep(3.5):linear(0.3):diffusealpha(1):sleep(2):linear(0.3):diffusealpha(0) end;
		};
		t[#t+1] = LoadActor("_flavorbar")..{
			InitCommand=function(self) self:Center():zoomy(0.8):diffusealpha(0) end;
			OnCommand=function(self) self:sleep(0.3):linear(0.2):diffusealpha(1):zoomy(0.5):sleep(0.8):linear(0.2):diffusealpha(0):zoomy(1) end;
		};
		t[#t+1] = LoadActor("_regflavor")..{
			InitCommand=function(self) self:Center():addx(-800):zoom(0.5) end;
			OnCommand=function(self) self:sleep(0.3):linear(0.2):Center():sleep(0.8):linear(0.2):addx(800) end;
		};
		t[#t+1] = LoadActor("_flavorthud")..{
			InitCommand=function(self) self:sleep(0.4):queuecommand("Play") end;
			PlayCommand=function(self) self:play() end;
		};
		t[#t+1] = LoadActor("_rise")..{
			InitCommand=function(self) self:sleep(1.1):queuecommand("Play") end;
			PlayCommand=function(self) self:play() end;
		};
		t[#t+1] = LoadActor("_stagesound")..{
			OnCommand=function(self) self:queuecommand("Play") end;
			PlayCommand=function(self) self:play() end;
		};
		t[#t+1] = Def.ActorFrame {
			InitCommand=function(self) self:Center():addy(120):zoom(1.4):diffusealpha(0) end;
			OnCommand=function(self) self:sleep(4.5):linear(0.1):diffusealpha(1):zoom(0.8):sleep(1.3):linear(0.3):diffusealpha(0) end;
				LoadFont("_pixellari 32px")..{
					--InitCommand=function(self) self:settext(sname) end;
					InitCommand=function(self)
						if ssname ~= nil then -- main and sub title
							self:settextf("%s\n\n%s",sname,ssname):addy(-10):zoom(0.7)
						elseif ssname == nil then -- main title
							self:settext(sname):addy(-15):zoom(0.9)
						end
					end;
				};
				LoadFont("_pixellari 32px")..{
					InitCommand=function(self)
						if ssname then 
							self:maxwidth(700):addy(23):zoom(0.9)
						else
							self:maxwidth(700):addy(18)
						end
					end;
					OnCommand=function(self) self:settext(sartist) end;
				};
		};
	end
end

return t
